            </div>
        </main>
    </div>

    <!-- Notifications Modal -->
    <div id="notificationsModal" class="fixed inset-0 bg-black/50 hidden z-50 flex items-center justify-center">
        <div class="bg-white rounded-xl w-full max-w-md mx-4 max-h-[80vh] overflow-hidden">
            <div class="p-4 border-b flex items-center justify-between">
                <h3 class="text-lg font-semibold">Notifications</h3>
                <button onclick="closeNotifications()" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div id="notificationsList" class="p-4 max-h-96 overflow-y-auto">
                <!-- Notifications will be loaded here -->
            </div>
        </div>
    </div>

    <script>
        // Initialize charts if chart canvases exist
        function initCharts() {
            if (document.getElementById('activityChart')) {
                const activityCtx = document.getElementById('activityChart').getContext('2d');
                new Chart(activityCtx, {
                    type: 'line',
                    data: {
                        labels: ['6am', '8am', '10am', '12pm', '2pm', '4pm', '6pm', '8pm'],
                        datasets: [{
                            label: 'Active Staff',
                            data: [12, 45, 78, 95, 88, 72, 45, 20],
                            borderColor: '#fc8100',
                            tension: 0.4,
                            fill: true,
                            backgroundColor: 'rgba(26, 33, 127, 0.1)'
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                display: false
                            }
                        },
                        scales: {
                            y: {
                                beginAtZero: true
                            }
                        }
                    }
                });
            }

            if (document.getElementById('checkinChart')) {
                const checkinCtx = document.getElementById('checkinChart').getContext('2d');
                new Chart(checkinCtx, {
                    type: 'doughnut',
                    data: {
                        labels: ['Verified', 'Pending', 'Failed'],
                        datasets: [{
                            data: [280, 45, 17],
                            backgroundColor: ['#22c55e', '#f59e0b', '#ef4444']
                        }]
                    },
                    options: {
                        responsive: true,
                        maintainAspectRatio: false,
                        plugins: {
                            legend: {
                                position: 'bottom'
                            }
                        }
                    }
                });
            }
        }

        // Notifications
        function loadNotifications() {
            const modal = document.getElementById('notificationsModal');
            modal.classList.remove('hidden');
            loadRecentActivity();
        }

        function closeNotifications() {
            document.getElementById('notificationsModal').classList.add('hidden');
        }

        async function loadRecentActivity() {
            try {
                const response = await fetch('api/activity.php?action=recent');
                const data = await response.json();
                
                const container = document.getElementById('notificationsList');
                if (data.success && data.data.length > 0) {
                    container.innerHTML = data.data.map(item => `
                        <div class="flex items-start gap-3 py-3 border-b last:border-0">
                            <div class="w-10 h-10 rounded-full bg-primary/10 flex items-center justify-center flex-shrink-0">
                                <i class="fas fa-${item.icon} text-primary"></i>
                            </div>
                            <div class="flex-1">
                                <p class="text-sm font-medium">${item.title}</p>
                                <p class="text-xs text-gray-500">${item.description}</p>
                                <p class="text-xs text-gray-400 mt-1">${item.time}</p>
                            </div>
                        </div>
                    `).join('');
                } else {
                    container.innerHTML = '<p class="text-gray-500 text-center py-4">No recent activity</p>';
                }
            } catch (error) {
                console.error('Error loading notifications:', error);
            }
        }

        // Auto-refresh SOS count every 30 seconds
        function refreshSOSCount() {
            fetch('api/sos.php?action=count')
                .then(res => res.json())
                .then(data => {
                    if (data.success) {
                        const badge = document.getElementById('sos-count');
                        if (badge) {
                            badge.textContent = data.count;
                            badge.style.display = data.count > 0 ? 'inline' : 'none';
                        }
                    }
                })
                .catch(console.error);
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', function() {
            initCharts();
            // Refresh SOS count every 30 seconds
            setInterval(refreshSOSCount, 30000);
        });

        // Close modal on outside click
        document.getElementById('notificationsModal')?.addEventListener('click', function(e) {
            if (e.target === this) {
                closeNotifications();
            }
        });
    </script>
</body>
</html>
